implementation module EdMyIO;

/* OS dependent module for linux */

import StdClass,StdFile, StdChar, StdInt, StdBool, StdString, StdMisc,StdArray;
import deltaFileSelect, deltaEventIO, deltaIOSystem, deltaSystem, deltaDialog;

import pointer;
import EdMyIO2;

NoDate	:== {exists=False,yy=0,mm=0,dd=0,h=0,m=0,s=0};

FOpenDir :: !String !*Files -> (!Bool, !*Files);
FOpenDir name disk = (False, disk);

FCloseDir :: !*Files -> !(Bool, !*Files);
FCloseDir disk = (False, disk);

FGetPlainFileName :: !*Files -> (!Bool, !String, !*Files);
FGetPlainFileName disk = (False, "", disk);

FRemove	:: !String !*Files -> (!Bool, !*Files);
FRemove path disk
	| unlink (path+++"\0")==0
		= (True,disk);
		= (False,disk);

unlink :: !String -> Int;
unlink string0 = code {
		ccall unlink "s:I"
	};

FStartUpDir :: !String !*Files -> (!String, !*Files);
FStartUpDir applicationname files
	# p=ApplicationPath "";
	= (p % (0,size p-2),files);
	
String64 :: String;
String64	= createArray 64 '@';

Older_Date	:: !DATE !DATE -> Bool;
Older_Date	{exists=b1,yy=yy1,mm=mm1,dd=dd1,h=h1,m=m1,s=s1}
			{exists=b2,yy=yy2,mm=mm2,dd=dd2,h=h2,m=m2,s=s2}
	| b1		&& not b2	= True;
	| not b1	|| not b2	= False;
							= Older_IntList [yy1,mm1,dd1,h1,m1,s1] [yy2,mm2,dd2,h2,m2,s2];
	
Older_IntList	:: ![Int] ![Int] -> Bool;
Older_IntList []		[]					=  False;
Older_IntList [h1:t1]	[h2:t2]	| h1 < h2	=  True;
								| h1 > h2	=  False;
											=  Older_IntList t1 t2;
											
FTempFileName :: !String !*Files -> (!String, !*Files);
FTempFileName dir disk
	= (dir+++toString DirSeparator+++"temp",disk);

SelectDir :: !*state !(IOState *state) -> (!Bool, !String, !*state, !IOState *state);
SelectDir state io
	=  (open, RemoveFileName dirname`, state`, io`);
	where {
	(open, dirname`, state`, io`)= SelectInputFile state io;
	};
		
RemoveFileName :: !String -> String;
RemoveFileName path
		| found	= path % (0, dec position);
				= path;
		where {
		(found,position)	= LastColon path last;
		last				= dec (size path);
		};

LastColon :: !String !Int -> (!Bool, !Int);
LastColon s i
	| i <= 0
		= (False,0);
	| DirSeparator==s.[i]
	 	= (True, i);
		= LastColon s (dec i);
		
Launch ::	!String *state !(IOState *state)
			-> (!Bool,!Int,!*state,!IOState *state);
Launch progname state io
	=  (True, 0, state`, io`);
	where {
	(_, state`,io`)	= OpenNotice notice state io;
	notice		= Notice [("Execute \'" +++ progname) +++ "\'"] (NoticeButton 1 "OK") [];
	};

GetFullApplicationPath :: !*Files -> ({#Char}, *Files);
GetFullApplicationPath files
	=	FStartUpDir "" files;
